spool sp_refresh_ws_station_data.log
--this is to create and/or populate ws_station_data temp table. This table should not be dropped on the production after WS refresh.

--drop table ws_station_data;
create table ws_station_data
(HYDROLOGIC_UNIT_CODE 	  	VARCHAR2 (12 CHAR),  
ORGANIZATION_ID 		VARCHAR2 (256 BYTE),  
ORGANIZATION_NAME		VARCHAR2 (256 BYTE),  
STATION_ID			VARCHAR2 (256 BYTE),  
STATION_NAME			VARCHAR2 (256 BYTE),  
MIN_ACTIVITY_START_DATE_TIME 	DATE,  
MAX_ACTIVITY_STOP_DATE_TIME 	DATE,  
CHARACTERISTIC_ID		NUMBER (12),  
CHAR_DISPLAY_NAME		VARCHAR2 (256 CHAR) , 
CHAR_RESULT_COUNT		NUMBER (12),  
UNIQUE_STATION_IDENTIFIER	VARCHAR2 (280 CHAR))  
tablespace storetdata  
storage (initial 20M next 5M)
nologging;

create or replace PROCEDURE         storetw.SP_REFRESH_WS_STATION_DATA AS
cursor station_data_cur is
select trim(station_char.hydrologic_unit_code) as hydrologic_unit_code,
	   trim(station_char.organization_id) as organization_id,
	   organization_name,
	   trim(station_char.station_id) as station_id, station_char.station_name,
	   act_min_start_date as min_activity_start_date_time,
	   act_max_start_stop_date as max_activity_stop_date_time,
	   fk_char as characteristic_id,
	   display_name as char_display_name,
	   result_count as char_result_count,
	   trim(station_char.organization_id) || ',' || trim(station_char.station_id)
	   									   	    as unique_station_identifier
	from station_char, di_org, fa_station
	where di_org.organization_id = station_char.organization_id
	  and station_char.fk_fa_statn = fa_station.pk_isn
	  and trim(upper(fa_station.location_point_type)) = '*POINT OF RECORD';

  v_huc									varchar2(12 char);
  v_organization_id						varchar2(256 byte);
  v_org_name							varchar2(256 byte);
  v_station_id							varchar2(256 byte);
  v_station_name						varchar2(256 byte);
  v_min_act_start_date					date;
  v_max_act_stop_date					date;
  v_char_id								number(12);
  v_char_display_name					varchar2(256 char);
  v_char_result_count					number(12);
  v_unique_station_identifier			varchar2(280 char);
  v_insert_count						number(12);
  v_create_stmt							varchar2(800 char);
  v_insert_stmt							varchar2(800 char);

begin

begin
execute immediate 'create index I_CCTYPE_FK_CHAR on characteristic_chartype(FK_CHARACTERISTIC) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 3M NEXT 3M)';
exception when others then null;
end;

begin
execute immediate 'create index I_CCTYPE_FK_CHARTYPE on characteristic_chartype(FK_CHARTYPE) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 3M NEXT 3M)';
exception when others then null;
end;

begin
execute immediate 'create index I_CTYPE_PKISN on LU_chartype(PK_ISN) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 3M NEXT 3M)';
exception when others then null;
end;


--clean up characteristic_chartype
delete from characteristic_chartype cc
where fk_chartype in (select pk_isn from lu_chartype
	where chartype='Measure N');

COMMIT;

delete from characteristic_chartype cc
where not exists (select 1 from lu_chartype ct
	where ct.pk_isn = cc.fk_chartype);

COMMIT;

delete from lu_chartype
where chartype='Measure N';
commit;

BEGIN
execute immediate 'ANALYZE TABLE CHARACTERISTIC_CHARTYPE COMPUTE STATISTICS FOR ALL INDEXES';
exception when others then null;
end;

BEGIN
execute immediate 'ANALYZE TABLE LU_CHARTYPE COMPUTE STATISTICS  FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;


--create ws_station_data
dbms_output.put_line('Creating ws_station_data table ...');


begin
  execute immediate 'truncate table ws_station_data';
exception when others then
  null;
end;

begin
execute immediate 'DROP index IWS_WST_CHAR_ID';
exception when others then null;
end;

begin
execute immediate 'DROP index IWS_WST_HUC_ORG_STATN';
exception when others then null;
end;

begin
execute immediate 'DROP index IWS_WST_HUC';
exception when others then null;
end;


--insert data into ws_station_data, while committing after every 1000 inserts
dbms_output.put_line('Populating ws_station_data table ...');
v_insert_count := 0;
open station_data_cur;
loop
	fetch station_data_cur into
	v_huc, v_organization_id,
	v_org_name, v_station_id,
	v_station_name, v_min_act_start_date,
  	v_max_act_stop_date, v_char_id,
	v_char_display_name, v_char_result_count,
	v_unique_station_identifier;
	exit when station_data_cur%NOTFOUND;

	insert into ws_station_data
	(hydrologic_unit_code, organization_id,
	 organization_name, station_id,
	 station_name, min_activity_start_date_time,
	 max_activity_stop_date_time, characteristic_id,
	 char_display_name, char_result_count,
	 unique_station_identifier)
	values
	(v_huc, v_organization_id,
	 v_org_name, v_station_id,
	 v_station_name, v_min_act_start_date,
	 v_max_act_stop_date, v_char_id,
	 v_char_display_name, v_char_result_count,
	 v_unique_station_identifier);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;
end loop;
close station_data_cur;
commit;

--create indexes on ws_station_data
dbms_output.put_line('Creating indexes on ws_station_data table ...');

begin
execute immediate 'create index IWS_WST_CHAR_ID on ws_station_data(characteristic_id) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 5M NEXT 5M)';
exception when others then null;
end;

begin
execute immediate 'create index IWS_WST_HUC_ORG_STATN on ws_station_data(hydrologic_unit_code, organization_id, station_id) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 5M NEXT 5M)';
exception when others then null;
end;

begin
execute immediate 'create index IWS_WST_HUC on ws_station_data(hydrologic_unit_code) ' ||
'TABLESPACE storetindx ' ||
'STORAGE (INITIAL 5M NEXT 5M)';
exception when others then null;
end;

BEGIN
execute immediate 'ANALYZE TABLE ws_station_data COMPUTE STATISTICS  FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;




end;
/
show errors;

select count(*) from storetw.ws_station_data;

set serveroutput on
--exec storetw.SP_REFRESH_WS_STATION_DATA;
--select count(*) from storetw.ws_station_data;

spool off;